package org.scec.useit.forecasting;

import java.io.File;
import java.io.IOException;
import java.util.List;

import org.opensha.sha.simulators.RSQSimEvent;

import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.kevin.simulators.RSQSimCatalog;
import scratch.kevin.simulators.RSQSimCatalog.Loader;

public class CatalogStandardPlotGenerator {

	public static void main(String[] args) throws IOException {
		// input catalog dir. At a minimum, this directory must contain the following 6 files
		// 		<prefix>.dList
		// 		<prefix>.eList
		// 		<prefix>.tList
		// 		<prefix>.pList
		// 		<parameter file>.in
		// 		<fault file>.flt or <fault fault>.in
		// 
		// The prefix for the 4 list files can be empty, so those files
		// could be called simply .pList, .eList, etc...
		// 
		// There is no convention for the name of the parameter file, except that is usually ends in ".in,"
		// though there can be multiple ".in" files and you'll need to make sure that the correct one is there.
		//
		// Similar for the fault input file. It's name will be listed in the 'faultFname' field in the parameter
		// file. It will typically end with ".in" or ".flt"
		File catalogDir = new File("/data/kevin/simulators/catalogs/rundir2585_1myr");
		// on windows, this would look something like: new File("C:\\Users\\intern\\<sub-dirs>...\\<catalog-dir>"

		RSQSimCatalog catalog = new RSQSimCatalog(catalogDir, "Catalog Name",
				FaultModels.FM3_1, DeformationModels.GEOLOGIC);
		// UCERF3 fault and deformation model used as input to the simulation
		// so far all have been FM 3.1/GEOLOGIC, you likely won't change these
		
		double plotMinMag = 6d;
		boolean plots = true; // true to include plots
		boolean replot = true; // regenerate all plots instead of just missing ones
		
		catalog.writeMarkdownSummary(catalogDir, plots, replot, plotMinMag);
	}

}
