package org.scec.useit.forecasting;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.*;
import org.opensha.sha.simulators.RSQSimEvent;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.kevin.simulators.RSQSimCatalog;
import scratch.kevin.simulators.RSQSimCatalog.Loader;
public class HiatusFinder {
	public static void main(String[] args) throws IOException {
		// input catalog dir. 
		File catalogDir = new File("C:\\Users\\Intern\\Desktop\\cygwin64\\home\\Intern\\FAST\\bruce_catalog"); // change path per computer
		// on windows, this would look something like: new File("C:\\Users\\intern\\<sub-dirs>...\\<catalog-dir>"

		RSQSimCatalog catalog = new RSQSimCatalog(catalogDir, "eqs.teamvandg.out", // chang file name based on catalog
				FaultModels.FM3_1, DeformationModels.GEOLOGIC);
		// UCERF3 fault and deformation model used as input to the simulation
		// so far all have been FM 3.1/GEOLOGIC, you likely won't change these
		
		// now load the events using catalog.loader()
		Loader loader = catalog.loader();

		// you'll almost always want to filter them as they are loaded to reduce memory requirements.
		
		Scanner input = new Scanner(System.in);
		System.out.println("Enter magnitude: ");
		double magnitude = input.nextDouble();
		System.out.println("Enter hiatus interval: ");
		int hiatus = input.nextInt();
		loader.minMag(magnitude);

		// we usually skip the first 5k years to avoid spin up time
		loader.skipYears(5000);
		
		// now read in the events, doing any calculations
		int eventCount = 0;
		double startTime = Double.NaN;
		double endTime = Double.NaN;
		for (RSQSimEvent event : loader.iterable()) {
			double timeYears = event.getTimeInYears();
			if (eventCount == 0)                      // Tests for first event in the catalog
				startTime = timeYears;
			else if(eventCount != 0) {
				endTime = timeYears;                  // sets current event year as the end year
				double duration = endTime - startTime;
				if(duration >= hiatus) {				// tests for 100 year hiatus and then prints start day 
					System.out.println("Start year: "+ startTime+ "\n" + "End year: " + endTime + "\n" + "Duration: "+ duration + " years\n");
				}
			startTime = endTime;
			}eventCount++; // to prevent 
		}
		
	}
}
