package org.scec.useit.forecasting.droughts;

import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.simulators.SimulatorEvent;

/**
 * Simplest drought type, based on minimum magnitude of any event in the catalog
 * @author Kevin Milner
 *
 */
public class CatalogMinMagDroughtType extends DroughtType {
	
	private ParameterList params;
	
	private DoubleParameter minMagParam;
	
	public CatalogMinMagDroughtType(double minMag) {
		params = new ParameterList();
		
		minMagParam = new DoubleParameter("Minimum Magnitude", 0d, 10d);
		minMagParam.setValue(minMag);
		params.addParameter(minMagParam);
	}

	@Override
	public String getName() {
		return "Catalog Minimum Magnitude";
	}

	@Override
	public boolean doesEventEndDrought(SimulatorEvent event) {
		return event.getMagnitude() >= minMagParam.getValue();
	}

	@Override
	public ParameterList getParameters() {
		return params;
	}

}
