package org.scec.useit.forecasting.droughts;

import java.util.ArrayList;
import java.util.List;

import org.opensha.sha.simulators.SimulatorEvent;

import com.google.common.base.Preconditions;

/**
 * This class keeps track of a drought period. A drought starts the instant that a drought-busting event
 * occurs, and lasts until the next drought-busting event
 * @author Kevin Milner
 */
public class DroughtPeriod {
	private final double startTimeYears;
	private final double endTimeYears;
	
	private final double durationYears;
	
	public DroughtPeriod(double startTimeYears, double endTimeYears) {
		this.startTimeYears = startTimeYears;
		this.endTimeYears = endTimeYears;
		Preconditions.checkState(endTimeYears > startTimeYears,
				"Drought end time (%s) must be > start time (%s)", endTimeYears, startTimeYears);
		durationYears = endTimeYears - startTimeYears;
	}
	
	/**
	 * @return the time (in years) at which this drought started. This is the exact time that the previous drought-busting
	 * event occurred
	 */
	public double getStartTime() {
		return startTimeYears;
	}
	
	/**
	 * @return the time (in years) at which this drought ended. This is the exact time that the next drought-busting event occurred.
	 */
	public double getEndTime() {
		return endTimeYears;
	}
	
	/**
	 * @return drought duration in years
	 */
	public double getDuration() {
		return durationYears;
	}
}
