package org.scec.useit.forecasting.droughts;

import org.opensha.commons.data.Named;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.simulators.SimulatorEvent;

public abstract class DroughtType implements Named {
	
	/**
	 * @param event
	 * @return true if this event ends a drought, false otherwise
	 */
	public abstract boolean doesEventEndDrought(SimulatorEvent event);
	
	/**
	 * @return list of adjustable parameters that define a drought
	 */
	public abstract ParameterList getParameters();

}
